unit Main;

//       
//  ,     
//    . (. unit Satelits, Planets)

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, ImgList,
  Satelits, Planets;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    Edit9: TEdit;
    Edit10: TEdit;
    CbBoxSort: TComboBox;
    CheckBoxUp: TCheckBox;
    Label11: TLabel;
    Image1: TImage;
    ListBox2: TListBox;
    Label12: TLabel;
    Edit11: TEdit;
    Label13: TLabel;
    Edit12: TEdit;
    Label14: TLabel;
    Edit13: TEdit;
    Label15: TLabel;
    Edit14: TEdit;
    Label16: TLabel;
    Edit15: TEdit;
    Label17: TLabel;
    Edit16: TEdit;
    Label18: TLabel;
    Edit17: TEdit;
    Edit18: TEdit;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label19: TLabel;
    Bevel3: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure SortClick(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure LoadSatelits(RqPlanet : TptPlanets);
    procedure ShowPlanetImage(RqPlanet : TptPlanets);
    procedure ShowPlanet(RqPlanet : TptPlanets);
    procedure ShowPlanetsList(RqList : array of TptPlanets);
    function  CompareRec (Rec1,Rec2 : TptPlanets; SortCmd : Char) : boolean;
    procedure SortArray(var RqArray  : array of TptPlanets; SortCmd : Char);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//     
var ptSortSolSys : array of TptPlanets;

//    
procedure TForm1.ListBox2Click(Sender: TObject);
var ptSat : TptSatelits;
begin
  if ListBox2.ItemIndex >= 0
  then begin
    ptSat := Pointer(ListBox2.Items.Objects[ListBox2.ItemIndex]);
    Edit11.Text := ptSat^.Name;
    Edit12.Text := ptSat^.Size;
    Edit13.Text := ptSat^.Orbit;
    Edit14.Text := ptSat^.Period;
    Edit15.Text := ptSat^.Mass;
    Edit16.Text := ptSat^.EDat;
  end;
end;

//     
procedure TForm1.LoadSatelits(RqPlanet : TptPlanets);
var Ind : integer;
begin
    ListBox2.Clear;
    Edit18.Text := RqPlanet.Name;
    if (RqPlanet^.ptSat <> nil) and
       (RqPlanet^.SatNum > 0)
    then begin
      for Ind := 0 to (RqPlanet^.SatNum - 1)
      do begin
        //      
        ListBox2.Items.AddObject(RqPlanet^.ptSat^[Ind].Name,
                                 Addr(RqPlanet^.ptSat^[Ind]));
      end;
      Edit17.Text := IntToStr(ListBox2.Items.Count);
    end;
end;

//   
procedure TForm1.ShowPlanetImage(RqPlanet : TptPlanets);
begin
  Image1.Visible := False;
  if RqPlanet^.FName <> ''
  then begin
    if FileExists('.\PImage\' + RqPlanet^.FName)
    then begin
      Image1.Picture.LoadFromFile('.\PImage\' + RqPlanet^.FName);
      Image1.Visible := True;
    end;
  end;
end;

//       
procedure TForm1.ShowPlanet(RqPlanet : TptPlanets);
begin
 with RqPlanet^ do
 begin
   Edit1.Text  := Name;                 //  
   Edit2.Text  := FloatToStr(Mass);     //  ()
   Edit3.Text  := FloatToStr(Diam);     //  (.)
   Edit4.Text  := FloatToStr(Dens);     //  (/c3)
   Edit5.Text  := FloatToStr(Tmax);     // . 
   Edit10.Text := FloatToStr(Tmin);     // . 
   Edit9.Text  := FloatToStr(Day);      //   (  )
   Edit8.Text  := FloatToStr(Orbit);    //    C (..)
   Edit7.Text  := FloatToStr(Period);   //     ( )
   Edit6.Text  := FloatToStr(SatNum);   // - 
   //    
   Edit11.Text := '';
   Edit12.Text := '';
   Edit13.Text := '';
   Edit14.Text := '';
   Edit15.Text := '';
   Edit16.Text := '';
   Edit17.Text := '0';
   //   
   ShowPlanetImage(RqPlanet);
   //   
   LoadSatelits(RqPlanet);
 end;
end;

//        
procedure TForm1.ShowPlanetsList(RqList : array of TptPlanets);
var Ind : integer;
begin
   ListBox1.Clear;
   if Length(RqList) >0
   then begin
     //   
     for Ind := Low(RqList) to High(RqList)
     do ListBox1.Items.Add(RqList[Ind]^.Name);
     //    ( ) 
     ShowPlanet(RqList[Low(RqList)]);
   end;
end;

//   
procedure TForm1.ListBox1Click(Sender: TObject);
begin
   if (ListBox1.ItemIndex >= 0) and
      (ListBox1.Count = Length(ptSortSolSys))
   then begin
     ShowPlanet(ptSortSolSys[ListBox1.ItemIndex]);
   end;
end;

//      
//    :
//  SortCmd = 'U'   Rec2     Rec1
//  SortCmd = 'D'   Rec2     Rec1
function TForm1.CompareRec (Rec1,Rec2 : TptPlanets; SortCmd  : Char) : boolean;
var P1, P2 : double;
begin
  Result := False;
  P1 := 0;  P2 := 0;
  if (Rec1 <> nil) and (Rec2 <> nil)
  then begin
     //  
     case CbBoxSort.ItemIndex of
     0 : begin  //  ()
            P1 := Rec1^.Mass;  P2 := Rec2^.Mass;
         end;       //  ()
     1 : begin //  (.)
            P1 := Rec1^.Diam;  P2 := Rec2^.Diam;
         end;
     2 : begin //  (/c3)
            P1 := Rec1^.Dens;  P2 := Rec2^.Dens;
         end;
     3 : begin // . 
           P1 := Rec1^.Tmax;  P2 := Rec2^.Tmax;
         end;
     4 : begin // . 
           P1 := Rec1^.Tmin;  P2 := Rec2^.Tmin;
         end;
     5 : begin //   (  )
           P1 := Rec1^.Day;  P2 := Rec2^.Day;
         end;
     6 : begin //    C (..)
           P1 := Rec1^.Orbit;  P2 := Rec2^.Orbit;
         end;
     7 : begin //     ( )
           P1 := Rec1^.Period;  P2 := Rec2^.Period;
         end;
     8 : begin // - 
           P1 := Rec1^.SatNum;  P2 := Rec2^.SatNum;
         end;
     end; // of case CbBoxSort.ItemIndex
     case UpCase(SortCmd) of
    'U': if P2 > P1 then Result := True;
    'D': if P2 < P1 then Result := True;
     end; // of case UpCase(SortCmd)
  end;
end;

//   ( )
procedure TForm1.SortArray(var RqArray  : array of TptPlanets;
                               SortCmd  : Char);
var TopInd : integer;
    Ind    : integer;     //  
    ptBuf  : TptPlanets;  //      
begin
  if Length(RqArray) > 1
  then begin
    //     
    //  
    TopInd := High(RqArray);
    repeat
       Ind := Low(RqArray);
       //   Low(RqArray)  
       //    
       //   .
       repeat
          ptBuf := RqArray[Ind];
          if (Ind + 1) <= TopInd
          then begin
            case UpCase(SortCmd) of
            'D': begin
                   if CompareRec(RqArray[Ind], RqArray[Ind+1], 'U')
                   //   
                   then begin
                     //    
                     RqArray[Ind] := RqArray[Ind + 1];
                     //    
                     RqArray[Ind + 1] := ptBuf;
                   end;
                 end;
            'U': begin
                   if  CompareRec(RqArray[Ind], RqArray[Ind+1], 'D')
                   //    
                   then begin
                     //    
                     RqArray[Ind] := RqArray[Ind + 1];
                     //    
                     RqArray[Ind + 1] := ptBuf;
                   end;
                end;
            end; // of case
          end;
          Ind := Ind + 1;
        until (Ind >= TopInd );
        //       TopInd.
        //   TopInd    .
        TopInd := TopInd - 1;
    until (TopInd <= Low(RqArray));
  end;
  // 
end;

//    CbBoxSort  CheckBoxUp
procedure TForm1.SortClick(Sender: TObject);
begin
   if CheckBoxUp.Checked
   then SortArray(ptSortSolSys, 'U')
   else SortArray(ptSortSolSys, 'D');
   //  
   ShowPlanetsList(ptSortSolSys);
end;

//       
//   
procedure TForm1.FormCreate(Sender: TObject);
var Ind : integer;
begin
   //       
   if Length(ptSolarSystem) > 0
   then begin
     SetLength(ptSortSolSys, Length(ptSolarSystem));
     for Ind := Low(ptSolarSystem) to High(ptSolarSystem)
     do ptSortSolSys[Ind] := ptSolarSystem[Ind];
   end;
   //  
   ShowPlanetsList(ptSortSolSys);
end;



end.
